#include <bits/stdc++.h>
using namespace std;

struct Vektor {

	long long x, y;
	double ugao;
	int indeks;

};

int main() {

	ios::sync_with_stdio(false);
	cin.tie(nullptr);

	int n;
	cin >> n;

	vector<Vektor> v(n);

	for (int i = 0; i < n; i++) {

		cin >> v[i].x >> v[i].y;
		v[i].ugao = atan2((double)v[i].y, (double)v[i].x);
		v[i].indeks = i + 1;

	}

	sort(v.begin(), v.end(), [](const Vektor &a, const Vektor &b) {

		return a.ugao < b.ugao;

	});

	vector<Vektor> dupli = v;

	for (auto &e : v) {

		Vektor t = e;
		t.ugao += 2 * M_PI;
		dupli.push_back(t);

	}

	const double EPS = 1e-12;

	long long tekX = 0, tekY = 0;
	long long bestX = 0, bestY = 0;
	int l = 0, bestL = 0, bestR = -1;

	for (int r = 0; r < (int)dupli.size(); r++) {

		tekX += dupli[r].x;
		tekY += dupli[r].y;

		while (dupli[r].ugao - dupli[l].ugao > M_PI + EPS or r - l + 1 > n) {

			tekX -= dupli[l].x;
			tekY -= dupli[l].y;
			l++;

		}

		long long cur = tekX * tekX + tekY * tekY;
		long long best = bestX * bestX + bestY * bestY;

		if (cur > best) {

			bestX = tekX;
			bestY = tekY;

			bestL = l;
			bestR = r;

		}
	}

	vector<int> res;

	for (int i = bestL; i <= bestR; i++) {

		res.push_back(dupli[i].indeks);

	}

	cout << res.size() << "\n";

	for (int x : res) cout << x << " ";

	cout << "\n";

	return 0;
}